using System;
using System.Security;
using System.Security.Cryptography;
using System.Collections.Generic;
using System.Text;

namespace DPAPIDemo
{
   class Program
   {
      static void Main(string[] args)
      {
         string messageToProtect = "aaaabbbbccccdddd";
         byte[] messageArray =
           System.Text.Encoding.GetEncoding(1250).GetBytes(messageToProtect);

         ProtectedMemory.Protect(messageArray, MemoryProtectionScope.SameLogon);

         // to powinno spowodowa wywietlenie 16 bajtw bezuytecznych danych
         Console.WriteLine(System.Text.Encoding.GetEncoding(1250).GetString(messageArray));

         ProtectedMemory.Unprotect(messageArray, MemoryProtectionScope.SameLogon);

         // teraz zawarto tablicy zostanie wywietlona poprawnie
         Console.WriteLine(System.Text.Encoding.GetEncoding(1250).GetString(messageArray));

         // dane chronione, ktre maj zosta uyte w strumieniu, w pliku itp.
         string fileMessage = "Purpurowy w trenuje loty o wicie...";
         byte[] fileMsgArray = System.Text.Encoding.GetEncoding(1250).GetBytes(fileMessage);

         // pewna tablica bajtw dla wprowadzenia entropii
         byte[] entropy = { 0, 1, 3, 5, 7, 9 };
         byte[] protectedMessage = ProtectedData.Protect(
           fileMsgArray, entropy, DataProtectionScope.CurrentUser);

         Console.WriteLine("Chroniona tablica bajtw:");
         Console.WriteLine(
           System.Text.Encoding.GetEncoding(1250).GetString(protectedMessage));

         byte[] clearMessage = ProtectedData.Unprotect(
           protectedMessage, entropy, DataProtectionScope.CurrentUser);
         Console.WriteLine("Niechronione/Odszyfrowane Dane:");
         Console.WriteLine(Encoding.GetEncoding(1250).GetString(clearMessage));

         Console.ReadLine();
      }
   }
}
